<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package goyto
 */
$categories = get_the_category();
$blog_btn_text = cs_get_option('blog_btn_text');
?>

<article id="post-<?php the_ID(); ?>" <?php post_class('gt-blog-list-item'); ?>>
	<div class="gt-blog-img position-relative">
		<?php if (has_post_thumbnail()) { ?>
			<div class="item-img">
				<?php the_post_thumbnail('full') ?>
			</div>
		<?php } ?>
	</div>
	<div class="blog-meta-author mt-20 d-flex justify-content-between align-items-center flex-wrap">
		<div class="blog-author d-flex align-items-center">
			<div class="inner-img">
				<?php goyto_main_author_avatars(44); ?>
			</div>
			<div class="inner-text text-uppercase">
				<?php the_author() ?>
			</div>
		</div>
		<div class="blog-meta text-uppercase">
			<a href="#"><i class="fal fa-comments"></i> <?php echo esc_attr(get_comments_number()); ?> <?php esc_html_e('comments', 'goyto'); ?></a>
			<a href="#"><i class="fal fa-calendar-alt"></i> <?php echo date(get_option('date_format')); ?></a>
		</div>
	</div>
	<div class="blog-text-wrap headline pera-content">
		<h3 class="blog_title"><a href="<?php the_permalink() ?>">
				<?php the_title(); ?>
			</a></h3>
			<?php the_excerpt(); ?>
		<a class="read_more text-uppercase" href="<?php the_permalink() ?>">
			<span>
			<?php if (!empty($blog_btn_text)) {
				echo esc_html($blog_btn_text);
			} else {
				esc_html_e('Read More', 'goyto');
			} ?>
			<i class="far fa-long-arrow-right"></i></span>
		</a>
	</div>
</article><!-- #post-<?php the_ID(); ?> -->