<?php
/**
 * The template for displaying trip-content in single trip
 *
 * This template can be overridden by copying it to yourtheme/wp-travel-engine/content-single-trip.php.
 *
 * @package Wp_Travel_Engine
 * @subpackage Wp_Travel_Engine/includes/templates
 * @since @release-version //TODO: change after travel muni is live
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $post;
do_action( 'wte_before_single_trip' );
?>
<main class="site-main">
<?php
/**
 * Trip gallery template.
 *
 * This template can be overridden by copying it to yourtheme/wp-travel-engine/single-trip/gallery.php.
 *
 * @package Wp_Travel_Engine
 * @subpackage Wp_Travel_Engine/includes/templates
 * @since @release-version //TODO: change after travel muni is live
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

wp_enqueue_style( 'jquery-fancy-box' );
wp_enqueue_script( 'jquery-fancy-box' );
wp_enqueue_script( 'owl-carousel' );
wp_enqueue_style( 'owl-carousel' );

global $post;
global $wp_query;

$is_main_slider = isset( $is_main_slider ) && $is_main_slider;

$wpte_trip_images               = get_post_meta( $post->ID, 'wpte_gallery_id', true );
$global_settings                = get_option( 'wp_travel_engine_settings', array() );
$show_featured_image_in_gallery = ! isset( $global_settings['show_featured_image_in_gallery'] ) || 'yes' === $global_settings['show_featured_image_in_gallery'];

$hide_featured_image = isset( $global_settings['feat_img'] ) && '1' == $global_settings['feat_img'];

if ( ! is_array( $wpte_trip_images ) ) {
    $wpte_trip_images = array();
}

if ( $show_featured_image_in_gallery && has_post_thumbnail( $post->ID ) ) {
    array_unshift( $wpte_trip_images, get_post_thumbnail_id( $post->ID ) );
}
?>
<div class="gt-hotel-details-nav-slider d-flex wpte-gallery-wrapper">
    <div class="gt-hotel-details-slider-nav swiper-container">
        <div class="swiper-wrapper">
            <?php
            foreach ( $wpte_trip_images as $image ) {
                $gallery_image_size = apply_filters( 'wp_travel_engine_trip_single_gallery_image_size', 'large' );
                $link               = wp_get_attachment_image_src( $image, $gallery_image_size );
                $image_alt          = get_post_meta( $image, '_wp_attachment_image_alt', true );
                if ( empty( $image_alt ) ) {
                    $image_alt = get_the_title( $image );
                }

                if ( isset( $link[0] ) ) :
                    ?>
                    <div class="swiper-slide" data-thumb="<?php echo esc_url( $link[0] ); ?>">
                        <div class="gt-hotel-nav-img">
                            <img alt="<?php echo esc_attr( $image_alt ); ?>" loading="lazy" itemprop="image" src="<?php echo esc_url( $link[0] ); ?>">
                        </div>
                    </div>
                    <?php
                endif;
            }
            ?>
        </div>
    </div>
    <div class="gt-hotel-details-slider-for swiper-container">
        <div class="swiper-wrapper">
            <?php
            foreach ( $wpte_trip_images as $image ) {
                $gallery_image_size = apply_filters( 'wp_travel_engine_trip_single_gallery_image_size', 'large' );
                $link               = wp_get_attachment_image_src( $image, $gallery_image_size );
                $image_alt          = get_post_meta( $image, '_wp_attachment_image_alt', true );
                if ( empty( $image_alt ) ) {
                    $image_alt = get_the_title( $image );
                }

                if ( isset( $link[0] ) ) :
                    ?>
                    <div class="swiper-slide" data-thumb="<?php echo esc_url( $link[0] ); ?>">
                        <div class="gt-hotel-for-img">
                            <img alt="<?php echo esc_attr( $image_alt ); ?>" loading="lazy" itemprop="image" src="<?php echo esc_url( $link[0] ); ?>">
                        </div>
                    </div>
                    <?php
                endif;
            }
            ?>
        </div>
    </div>
    <?php if ( is_singular( 'trip' ) && isset( $args ) && ! isset( $args['related_query'] ) ) : ?>
        <div class="wpte-gallery-container">
            <?php
            global $post;
            $random                   = rand();
            $wp_travel_engine_setting = get_post_meta( $post->ID, 'wp_travel_engine_setting', true );
            $wpte_trip_images         = get_post_meta( $post->ID, 'wpte_gallery_id', true );
            if ( isset( $wpte_trip_images['enable'] ) && $wpte_trip_images['enable'] == '1' ) {
                if ( count( $wpte_trip_images ) > 1 ) {
                    unset( $wpte_trip_images['enable'] );
                    ?>
                <span class="wp-travel-engine-image-gal-popup">
                    <a
                        data-galtarget="#wte-image-gallary-popup-<?php echo esc_attr( $post->ID . $random ); ?>"
                        data-variable="<?php echo esc_attr( 'wteimageGallery' . $random ); ?>"
                        href="#wte-image-gallary-popup-<?php echo esc_attr( $post->ID . $random ); ?>"
                        class="wte-trip-image-gal-popup-trigger"><?php echo esc_html_e( 'Gallery', 'goyto' ); ?>
                    </a>
                </span>
                    <?php
                    $gallery_images = array_map(
                        function( $image ) {
                            return array( 'src' => wp_get_attachment_image_url( $image, 'large' ) );
                        },
                        $wpte_trip_images
                    );
                    ?>
                <script type="text/javascript">
                    jQuery(function($){
                        $('.wte-trip-image-gal-popup-trigger').on( 'click', function(){
                            jQuery.fn.fancybox && $.fancybox.open(<?php echo wp_json_encode( array_values( $gallery_images ) ); ?>,{
                                buttons: [
                                    "zoom",
                                    "slideShow",
                                    "fullScreen",
                                    "close"
                                ]
                            });
                        });
                    });
                </script>
                    <?php
                }
            }
            if ( isset( $wp_travel_engine_setting['enable_video_gallery'] ) && $wp_travel_engine_setting['enable_video_gallery'] == true ) {
                echo do_shortcode( '[wte_video_gallery label="Video"]' );
            }
            ?>
        </div>
    <?php endif; ?>
</div>
<?php
/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
?>

	<article id="post-<?php the_ID(); ?>" <?php post_class( 'trip-post' ); ?>>
		<?php
			/**
			 * wte_single_trip_content hook.
			 *
			 * @hooked display_single_trip_title - 5
			 * @hooked display_single_trip_gallery - 10
			 * @hooked display_single_trip_content - 15
			 * @hooked display_single_trip_tabs_nav - 20
			 * @hooked display_single_trip_tabs_content - 25
			 */
			do_action( 'wte_single_trip_content' );

			/**
			 * wte_single_trip_footer hook.
			 *
			 * @hooked display_single_trip_footer - 5
			 */
			do_action( 'wte_single_trip_footer' );

			/**
			 * display_wte_rich_snippet hook.
			 *
			 * @hooked wp_travel_engine_json_ld
			 */
			do_action( 'display_wte_rich_snippet' );
		?>
	</article>
	<!-- .article -->
</main>
<!-- ./main -->

<?php
do_action( 'wte_after_single_trip' );

/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
