<?php
/**
 * Single Trip Content
 *
 * Closing entry-content div is left out on purpose!.
 *
 * This template can be overridden by copying it to yourtheme/wp-travel-engine/single-trip/trip-content.php.
 *
 * @package Wp_Travel_Engine
 * @subpackage Wp_Travel_Engine/includes/templates
 * @since @release-version //TODO: change after travel muni is live
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
?>

<div class="entry-content">
	<?php
	if ( isset( $settings['departure']['section'] ) ) {
		if ( ! isset( $post_meta['departure_dates']['section'] ) ) {
			do_action( 'Wte_Fixed_Starting_Dates_Action' );
		}
	}
	?>

	<div class="trip-post-content">
		<?php the_content();
		if (get_post_meta(get_the_ID(), 'goyto_trip_meta', true)) {
			$trip_meta = get_post_meta(get_the_ID(), 'goyto_trip_meta', true);
		} else {
			$trip_meta = array();
		}
		
		if (array_key_exists('trips_infos', $trip_meta)) {
			$trips_infos = $trip_meta['trips_infos'];
		} else {
			$trips_infos = '';
		}
		?>
		<?php if(!empty($trips_infos)):?>
		<div class="gt-tour-details-info d-flex mb-40 flex-wrap">
			<?php 
				
			foreach($trips_infos as $item):?>
			<div class="gt-td-info-item d-flex align-items-center">
				<div class="inner-icon d-flex align-items-center justify-content-center">
					<img src="<?php echo esc_url($item['image']['url']);?>" alt="">
				</div>
				<div class="inner-text headline">
					<span><?php echo esc_html($item['info_title']);?></span>
					<h3><?php echo esc_html($item['info_info']);?></h3>
				</div>
			</div>
			<?php endforeach;?>
		</div>
		<?php endif;?>
	</div>
	<!-- ./trip-post-content -->

<?php
/* Omit closing PHP tag at the end of PHP files to avoid "headers already sent" issues. */
